/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE Ogg Vorbis SOFTWARE CODEC SOURCE CODE.  *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS SOURCE IS GOVERNED BY *
 * THE GNU PUBLIC LICENSE 2, WHICH IS INCLUDED WITH THIS SOURCE.    *
 * PLEASE READ THESE TERMS DISTRIBUTING.                            *
 *                                                                  *
 * THE OggSQUISH SOURCE CODE IS (C) COPYRIGHT 1994-2000             *
 * by Monty <monty@xiph.org> and The XIPHOPHORUS Company            *
 * http://www.xiph.org/                                             *
 *                                                                  *
 ********************************************************************

  function: lookup data; generated by lookups.pl; edit there
  last mod: $Id: lookup_data.h,v 1.1.2.1 2000/09/26 22:31:50 xiphmont Exp $

 ********************************************************************/

#ifndef _V_LOOKUP_DATA_H_

#ifdef FLOAT_LOOKUP
#define COS_LOOKUP_SZ 128
static float COS_LOOKUP[COS_LOOKUP_SZ+1]={
	+1.0000000000000,+0.9996988186962,+0.9987954562052,+0.9972904566787,
	+0.9951847266722,+0.9924795345987,+0.9891765099648,+0.9852776423889,
	+0.9807852804032,+0.9757021300385,+0.9700312531945,+0.9637760657954,
	+0.9569403357322,+0.9495281805930,+0.9415440651830,+0.9329927988347,
	+0.9238795325113,+0.9142097557035,+0.9039892931234,+0.8932243011955,
	+0.8819212643484,+0.8700869911087,+0.8577286100003,+0.8448535652497,
	+0.8314696123025,+0.8175848131516,+0.8032075314806,+0.7883464276266,
	+0.7730104533627,+0.7572088465065,+0.7409511253550,+0.7242470829515,
	+0.7071067811865,+0.6895405447371,+0.6715589548470,+0.6531728429538,
	+0.6343932841636,+0.6152315905806,+0.5956993044924,+0.5758081914178,
	+0.5555702330196,+0.5349976198871,+0.5141027441932,+0.4928981922298,
	+0.4713967368260,+0.4496113296546,+0.4275550934303,+0.4052413140050,
	+0.3826834323651,+0.3598950365350,+0.3368898533922,+0.3136817403989,
	+0.2902846772545,+0.2667127574749,+0.2429801799033,+0.2191012401569,
	+0.1950903220161,+0.1709618887603,+0.1467304744554,+0.1224106751992,
	+0.0980171403296,+0.0735645635997,+0.0490676743274,+0.0245412285229,
	+0.0000000000000,-0.0245412285229,-0.0490676743274,-0.0735645635997,
	-0.0980171403296,-0.1224106751992,-0.1467304744554,-0.1709618887603,
	-0.1950903220161,-0.2191012401569,-0.2429801799033,-0.2667127574749,
	-0.2902846772545,-0.3136817403989,-0.3368898533922,-0.3598950365350,
	-0.3826834323651,-0.4052413140050,-0.4275550934303,-0.4496113296546,
	-0.4713967368260,-0.4928981922298,-0.5141027441932,-0.5349976198871,
	-0.5555702330196,-0.5758081914178,-0.5956993044924,-0.6152315905806,
	-0.6343932841636,-0.6531728429538,-0.6715589548470,-0.6895405447371,
	-0.7071067811865,-0.7242470829515,-0.7409511253550,-0.7572088465065,
	-0.7730104533627,-0.7883464276266,-0.8032075314806,-0.8175848131516,
	-0.8314696123025,-0.8448535652497,-0.8577286100003,-0.8700869911087,
	-0.8819212643484,-0.8932243011955,-0.9039892931234,-0.9142097557035,
	-0.9238795325113,-0.9329927988347,-0.9415440651830,-0.9495281805930,
	-0.9569403357322,-0.9637760657954,-0.9700312531945,-0.9757021300385,
	-0.9807852804032,-0.9852776423889,-0.9891765099648,-0.9924795345987,
	-0.9951847266722,-0.9972904566787,-0.9987954562052,-0.9996988186962,
	-1.0000000000000,
};

#define INVSQ_LOOKUP_SZ 32
static float INVSQ_LOOKUP[INVSQ_LOOKUP_SZ+1]={
	1.414213562373,1.392621247646,1.371988681140,1.352246807566,
	1.333333333333,1.315191898443,1.297771369046,1.281025230441,
	1.264911064067,1.249390095109,1.234426799697,1.219988562661,
	1.206045378311,1.192569588000,1.179535649239,1.166919931983,
	1.154700538379,1.142857142857,1.131370849898,1.120224067222,
	1.109400392450,1.098884511590,1.088662107904,1.078719779941,
	1.069044967650,1.059625885652,1.050451462878,1.041511287847,
	1.032795558989,1.024295039463,1.016001016002,1.007905261358,
	1.000000000000,
};

#define INVSQ2EXP_LOOKUP_MIN -32
#define INVSQ2EXP_LOOKUP_MAX 32
static float INVSQ2EXP_LOOKUP[INVSQ2EXP_LOOKUP_MAX-\
                              INVSQ2EXP_LOOKUP_MIN+1]={
	          65536,    46340.95001,          32768,    23170.47501,
	          16384,     11585.2375,           8192,    5792.618751,
	           4096,    2896.309376,           2048,    1448.154688,
	           1024,    724.0773439,            512,     362.038672,
	            256,     181.019336,            128,    90.50966799,
	             64,      45.254834,             32,      22.627417,
	             16,     11.3137085,              8,    5.656854249,
	              4,    2.828427125,              2,    1.414213562,
	              1,   0.7071067812,            0.5,   0.3535533906,
	           0.25,   0.1767766953,          0.125,  0.08838834765,
	         0.0625,  0.04419417382,        0.03125,  0.02209708691,
	       0.015625,  0.01104854346,      0.0078125, 0.005524271728,
	     0.00390625, 0.002762135864,    0.001953125, 0.001381067932,
	   0.0009765625, 0.000690533966,  0.00048828125, 0.000345266983,
	 0.000244140625,0.0001726334915,0.0001220703125,8.631674575e-05,
	6.103515625e-05,4.315837288e-05,3.051757812e-05,2.157918644e-05,
	1.525878906e-05,
};

#endif

#define FROMdB_LOOKUP_SZ 35
#define FROMdB2_LOOKUP_SZ 32
#define FROMdB_SHIFT 5
#define FROMdB2_SHIFT 3
#define FROMdB2_MASK 31
static float FROMdB_LOOKUP[FROMdB_LOOKUP_SZ]={
	              1,   0.6309573445,   0.3981071706,   0.2511886432,
	   0.1584893192,            0.1,  0.06309573445,  0.03981071706,
	  0.02511886432,  0.01584893192,           0.01, 0.006309573445,
	 0.003981071706, 0.002511886432, 0.001584893192,          0.001,
	0.0006309573445,0.0003981071706,0.0002511886432,0.0001584893192,
	         0.0001,6.309573445e-05,3.981071706e-05,2.511886432e-05,
	1.584893192e-05,          1e-05,6.309573445e-06,3.981071706e-06,
	2.511886432e-06,1.584893192e-06,          1e-06,6.309573445e-07,
	3.981071706e-07,2.511886432e-07,1.584893192e-07,
};

static float FROMdB2_LOOKUP[FROMdB2_LOOKUP_SZ]={
	   0.9928302478,   0.9786445908,   0.9646616199,   0.9508784391,
	   0.9372921937,     0.92390007,   0.9106992942,   0.8976871324,
	   0.8848608897,   0.8722179097,   0.8597555737,   0.8474713009,
	    0.835362547,   0.8234268041,   0.8116616003,   0.8000644989,
	   0.7886330981,   0.7773650302,   0.7662579617,    0.755309592,
	   0.7445176537,   0.7338799116,   0.7233941627,   0.7130582353,
	   0.7028699885,   0.6928273125,   0.6829281272,   0.6731703824,
	   0.6635520573,   0.6540711597,   0.6447257262,   0.6355138211,
};

#ifdef INT_LOOKUP

#define INVSQ_LOOKUP_I_SHIFT 10
#define INVSQ_LOOKUP_I_MASK 1023
static long INVSQ_LOOKUP_I[64+1]={
	   92682,   91966,   91267,   90583,
	   89915,   89261,   88621,   87995,
	   87381,   86781,   86192,   85616,
	   85051,   84497,   83953,   83420,
	   82897,   82384,   81880,   81385,
	   80899,   80422,   79953,   79492,
	   79039,   78594,   78156,   77726,
	   77302,   76885,   76475,   76072,
	   75674,   75283,   74898,   74519,
	   74146,   73778,   73415,   73058,
	   72706,   72359,   72016,   71679,
	   71347,   71019,   70695,   70376,
	   70061,   69750,   69444,   69141,
	   68842,   68548,   68256,   67969,
	   67685,   67405,   67128,   66855,
	   66585,   66318,   66054,   65794,
	   65536,
};

#define COS_LOOKUP_I_SHIFT 9
#define COS_LOOKUP_I_MASK 511
#define COS_LOOKUP_I_SZ 128
static long COS_LOOKUP_I[COS_LOOKUP_I_SZ+1]={
	   16384,   16379,   16364,   16340,
	   16305,   16261,   16207,   16143,
	   16069,   15986,   15893,   15791,
	   15679,   15557,   15426,   15286,
	   15137,   14978,   14811,   14635,
	   14449,   14256,   14053,   13842,
	   13623,   13395,   13160,   12916,
	   12665,   12406,   12140,   11866,
	   11585,   11297,   11003,   10702,
	   10394,   10080,    9760,    9434,
	    9102,    8765,    8423,    8076,
	    7723,    7366,    7005,    6639,
	    6270,    5897,    5520,    5139,
	    4756,    4370,    3981,    3590,
	    3196,    2801,    2404,    2006,
	    1606,    1205,     804,     402,
	       0,    -401,    -803,   -1204,
	   -1605,   -2005,   -2403,   -2800,
	   -3195,   -3589,   -3980,   -4369,
	   -4755,   -5138,   -5519,   -5896,
	   -6269,   -6638,   -7004,   -7365,
	   -7722,   -8075,   -8422,   -8764,
	   -9101,   -9433,   -9759,  -10079,
	  -10393,  -10701,  -11002,  -11296,
	  -11584,  -11865,  -12139,  -12405,
	  -12664,  -12915,  -13159,  -13394,
	  -13622,  -13841,  -14052,  -14255,
	  -14448,  -14634,  -14810,  -14977,
	  -15136,  -15285,  -15425,  -15556,
	  -15678,  -15790,  -15892,  -15985,
	  -16068,  -16142,  -16206,  -16260,
	  -16304,  -16339,  -16363,  -16378,
	  -16383,
};

#endif

#endif
