<?php

//! авторизационный токен
class CToken
{
	public function __construct()
	{
		$this->m_iExpire = 0;
		$this->m_iAge = 0;
		$this->m_aData = [];
	}

	//************************************************************************

	public function create($aData)
	{
		$this->m_iExpire = time() + TOKEN_LIFETIME;
		$this->m_iAge = 1;
		$this->m_aData = $aData;
	}

	//************************************************************************

	public function load($sToken)
	{
		if(!($aToken = dc::decode($sToken)))
			return false;

		$this->m_aData = $aToken[0];
		$this->m_iExpire = $aToken[1];
		$this->m_iAge = $aToken[2];

		return true;
	}

	//************************************************************************
	
	public function refresh()
	{
		$this->m_iExpire = time() + TOKEN_LIFETIME;
	}

	//************************************************************************

	public function gen()
	{
		$aData = [$this->m_aData, $this->m_iExpire, $this->m_iAge + 1];
		return dc::encode($aData);
	}

	//************************************************************************

	public function isValid()
	{
		return($this->m_iExpire > time() && $this->m_iAge < TOKEN_AGE_MAX);
	}

	//************************************************************************

	public function getData()
	{
		return $this->m_aData;
	}

	//***********************************************************************

	public function getExpire()
	{
		return $this->m_iExpire;
	}

	//########################################################################
	// PROTECTED
	//########################################################################

	protected $m_iExpire = 0;
	protected $m_iAge = 0;
	protected $m_aData = null;
}
