<?php

defined('FILE_PROTECTION') or die('restricted access');

//##########################################################################

/* шифрование/дешифрование токена, взято у Evgeny Danilovich admin@ds-servers.com */
class dc
{
	static public function encode($data)
	{
		return(self::encrypt(serialize($data)));
	}
	
	static public function decode($str)
	{
		if($data = self::decrypt($str))
			return(unserialize($data));

		return null;
	}

	//########################################################################
	
	static protected function encrypt($string)
	{
		$output = false;

		$encrypt_method = "AES-256-CBC";
		
		$secret_key = self::getKey();
		
		$secret_iv = openssl_random_pseudo_bytes(16);
		

		// hash
		$key = hash('sha256', $secret_key);
		
		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr(hash('sha256', $secret_iv), 0, 16);

		$string = gzdeflate($string);
				
		
		$output = openssl_encrypt($string, $encrypt_method, $key, OPENSSL_RAW_DATA, $iv);
		
		$output = $secret_iv.$output;
		
		$output = base64_encode(gzdeflate($output));
		
		$output = rtrim(strtr($output, '+/', '-_'), '=');
		
		return($output);
	}
	
	static protected function decrypt($string)
	{
		$output = false;

		$encrypt_method = "AES-256-CBC";
		$secret_key = self::getKey();

		// hash
		$key = hash('sha256', $secret_key);
		
		$string = str_pad(strtr($string, '-_', '+/'), strlen($string) % 4, '=', STR_PAD_RIGHT);
		
		if(!($data = base64_decode($string, true)))
			return null;

		$data = gzinflate($data);

		$secret_iv = substr($data, 0, 16);
		$data = substr($data, 16);
		
		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr(hash('sha256', $secret_iv), 0, 16);

		$output = openssl_decrypt($data, $encrypt_method, $key, OPENSSL_RAW_DATA, $iv);
		
		$output = gzinflate($output);
		
		return($output);
	}

	static protected function getKey()
	{
		return("Encryption key");
	}
}
