<?php

class token
{
	//! генерация токена
	static public function gen($data, $sVerify="")
	{
		$oToken = new CToken();
		$oToken->create([$sVerify, $data]);
		return $oToken;
	}

	//************************************************************************

	//! обновление токена
	static public function update($sToken)
	{
		$oToken = new CToken();
		$oToken->load($sToken);
		
		if($oToken->isValid())
		{
			$oToken->refresh();
			return $oToken;
		}

		return null;
	}

	//************************************************************************

	/** извлечение данных токена
		@param sToken токен 
		@param sVerify проверочная строка
		@return в случае успеха декодированные данные внутри токена, иначе null
	*/
	static public function extract($sToken, $sVerify="")
	{
		$oToken = new CToken();
		
		if(
			!$oToken->load($sToken) ||
			!($aData = $oToken->getData()) ||
			!$oToken->isValid() || 
			!is_array($aData) || count($aData) == 0 || !array_key_exists(0, $aData) || $aData[0] != $sVerify
		)
			return null;
		
		return $aData[1];
	}
}
